import type { Schema } from "../resource"
// @ts-ignore
import { env } from "$amplify/env/list-all-users"
import {
  CognitoIdentityProviderClient,
  ListUsersInGroupCommand,
} from "@aws-sdk/client-cognito-identity-provider"

type Handler = Schema["listAllUsers"]["functionHandler"]
const client = new CognitoIdentityProviderClient()

export const handler: Handler = async () => {
  const userPoolId = getUserpoolFromLambdaEnvironment(env)
  const adminCommand = new ListUsersInGroupCommand({
    UserPoolId: userPoolId,
    GroupName: env.BACKEND_AWS_COGNITO_ADMIN_GROUP_NAME
  })

  const viewerCommand = new ListUsersInGroupCommand({
    UserPoolId: userPoolId,
    GroupName: env.BACKEND_AWS_COGNITO_VIEWER_GROUP_NAME
  })

  const [adminResponse, viewerResponse] = await Promise.all([
    client.send(adminCommand),
    client.send(viewerCommand),
  ])

  return {
    admin: adminResponse,
    viewer: viewerResponse,
  }
}

function INTERNAL__generateEnvironmentUserpoolKey() {
  return `${env.BACKEND_AWS_COGNITO_RESOURCE_NAME_PREFIX.toUpperCase()}_USERPOOL_ID`
}

export function getUserpoolFromLambdaEnvironment(lambdaEnvironment: Record<string, string>) {
  const key = INTERNAL__generateEnvironmentUserpoolKey()
  return lambdaEnvironment[key]
}
